function [sorted] = sortxlstable(data)
%This little function takes an excel table of protein names and values and
%sorts them according to the protein names.
%Synatax:   [sorted] = sortxlstable(data)
%Input:     data = xlstable data.  In the form of a cell array with one row
%               text (protein names), one row values.
%Output:    sorted = the sorted data table

%first take the table and grab all of the file names to make a single list
%of names
labels = [];    %initiate
for i = 1:size(data,1)  %go through rows
    if ischar(data{i,1})     %if string concat
        labels = [labels,data(i,:)];
    end
end
labels = unique(labels);
if isempty(labels{1})   %check if the first cell is empty
    labels(1) = [];     %remove the first cell
end

%now go through each row and sort our the data according to label
for j = 1:size(labels,2)    %go through each label
    idx = 0;
    for k = 1:2:size(data,1)    %every other row
        idx = idx+1;
        for l = 1:size(data,2)  %every cell
            if strcmp(labels(j),data(k,l))  %found it
                sorted(idx,j) = data(k+1,l);
            end
        end        
    end
end

%add on the labels
sorted = vertcat(labels,sorted);